@extends('layout')
@section('content')
    @include('partials.breadcrumb')



    <!-- register begin-->
    <div class="contact register">
        <div class="container">


            <div class="row">
                @if($basic->registration == 0)
                    <div class="col-lg-12">
                        <div class="section-title text-center ">
                            <h2 class="title text-danger"> {{__($page_title)}} @lang('Has been Deactivated By Admin')</h2>
                        </div>
                    </div>

                @else
                <div class="col-xl-12 col-lg-12">
                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            {{ session('success') }}
                        </div>
                    @endif
                    @if (session('danger'))
                        <div class="alert alert-danger alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            {{ session('danger') }}
                        </div>
                    @endif

                    <form class="contact-form" action="{{route('register')}}" method="post">
                        @csrf

                        @if(isset($reference))
                            <input type="hidden" name="referBy"  value="{{$reference}}">
                        @endif


                        <div class="row">
                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label for="fname">@lang('First Name')<span class="requred">*</span></label>
                                    <input type="text" value="{{old('fname')}}" name="fname" id="fname" class="form-control"  placeholder="@lang('Enter Your First Name')" autocomplete="off" required>
                                    @if ($errors->has('fname'))
                                        <span class="error">{{ $errors->first('fname') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label for="fname">@lang('Last Name')<span class="requred">*</span></label>
                                    <input type="text" value="{{old('lname')}}" name="lname" id="lname" class="form-control"  placeholder="@lang('Enter Your Last Name')" autocomplete="off" required>
                                    @if ($errors->has('lname'))
                                        <span class="error">{{ $errors->first('lname') }}</span>
                                    @endif
                                </div>
                            </div>




                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('E-mail')<span class="requred">*</span></label>
                                    <input type="email" value="{{old('email')}}" name="email" id="email"  class="form-control checkUserEmail" placeholder="@lang('Enter Your E-mail')" required>
                                    @if ($errors->has('email'))
                                        <span class="error">{{ $errors->first('email') }}</span>
                                    @endif
                                    <span class="checkUserEmailMsg text-danger"></span>
                                </div>
                            </div>

                           <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Contact Number')<span class="requred">*</span></label>
                                    <input type="text" value="{{old('phone')}}" name="phone" id="phone" class="form-control " placeholder="@lang('Enter Your Contact Number')" required>
                                    @if ($errors->has('phone'))
                                        <span class="error">{{ $errors->first('phone') }}</span>
                                    @endif
                                </div>
                            </div>



                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label>@lang('User Name')<span class="requred">*</span></label>
                                    <input type="text" value="{{old('username')}}" name="username" id="username" class="form-control checkUsername" placeholder="@lang('Enter Your Username')" required>
                                    @if ($errors->has('username'))
                                        <span class="error">{{ $errors->first('username') }}</span>
                                    @endif
                                    <span class="checkUsernameMsg text-danger"></span>
                                </div>
                            </div>

 

                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Password')<span class="requred">*</span></label>
                                    <input type="password" name="password" class="form-control" placeholder="@lang('Enter Your Password')" required>
                                    @if ($errors->has('password'))
                                        <span class="error">{{ $errors->first('password') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Re-type Password')<span class="requred">*</span></label>
                                    <input type="password" name="password_confirmation" class="form-control" placeholder="@lang('Re-type Password')">
                                    @if ($errors->has('password_confirmation'))
                                        <span class="error">{{ $errors->first('password_confirmation') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6">
                                <button type="submit" class="submit-button btn-continue">@lang('Register Now')</button>
                            </div>
                        </div>
                    </form>
                </div>
                @endif
            </div>
        </div>
    </div>
    <!-- register end -->

@endsection


@section('js')
    <script>
        $(document).ready(function () {
            $(".checkUserEmail").on('keyup', function(){
                var email = $('.checkUserEmail').val();
                $.ajax({
                    type: "post",
                    url: "{{route('checkMail')}}",
                    data: {
                        email : email
                    },
                    success:function(data){
                        if(data.status == "existEmail")
                        {
                            $('.checkUserEmailMsg').text("This Email already Exist!!");
                            $('.btn-continue').attr('disabled',true);
                        }else{
                             $('.checkUserEmailMsg').text("");
                             $('.btn-continue').attr('disabled',false);
                        }
                        console.log(data)
                    },
                    error:function(data){

                    }
                })
            });

            $(".checkUsername").on('keyup', function(){
                var username = $('.checkUsername').val();
                $.ajax({
                    type: "post",
                    url: "{{route('checkUsername')}}",
                    data: {
                        username : username
                    },
                    success:function(data){
                        if(data.status == "existUsername")
                        {
                            $('.checkUsernameMsg').text("This Username already Exist!!");
                            $('.btn-continue').attr('disabled',true);
                        }else{
                             $('.checkUsernameMsg').text("");
                             $('.btn-continue').attr('disabled',false);
                        }
                        console.log(data)
                    },
                    error:function(data){

                    }
                })
            });
        });
    </script>
@stop